function [p consts] = calc_p(loc, d)

%% define additional inputs

% define production constants
consts = bedrock_constants();

% vector over which to calculate muon production rates
consts.prezg = [0 logspace(0, 6, 500)]; % g/cm2
% consts.rho = 2.65;
consts.Lsp = 160; % probably not appropriate for the Arctic. Might want 140 or 150.

%% Make calculations

for a = 1:length(loc)

    this_p.h = ERA40atm(loc{a}.lat,loc{a}.lon,loc{a}.elv); % site air pressure
   
    % Define production rate info
    this_p.SFsp = stone2000(loc{a}.lat,this_p.h,1); % scaling factor
    
    % Build a data structure with production rate information
    this_p.P10sp = consts.P10q_St .* this_p.SFsp; % Be-10 spallation production rate at surface
    this_p.P26sp = this_p.P10sp.*consts.R2610q; % Al-26 spallation production rate at surface
    this_p.P14sp = consts.P14q_St .* this_p.SFsp; % C-14 spallation production rate at surface

    this_p.thick_sf = thickness(d{a}.thick_gcm, consts.Lsp, 1);
    
    % precalculate muon production rates for to some deep depth. zeros
    % below ~1.95e+05 g cm-2. 
    
     this_p.premu10 = zeros(length(consts.prezg), 1);
     this_p.premu26 = this_p.premu10;
     this_p.premu14 = this_p.premu10;
    
     this_p.premu10(1:find(consts.prezg<2e5, 1, 'last'), 1) = P_mu_total_alpha1(consts.prezg(consts.prezg<2e5), this_p.h, consts.mc10q);
     this_p.premu26(1:find(consts.prezg<2e5, 1, 'last'), 1) = P_mu_total_alpha1(consts.prezg(consts.prezg<2e5), this_p.h, consts.mc26q);
     this_p.premu14(1:find(consts.prezg<2e5, 1, 'last'), 1) = P_mu_total_alpha1(consts.prezg(consts.prezg<2e5), this_p.h, consts.mc14q);

     if sum(this_p.premu10<0) ~=0 % should this be >0?
         warning('There is a negative muon production rate at depth for this sample')
     else
     end

     p{a} = this_p;

end




end